--------------------------------------------------------
-- added to make below compile
--------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
--------------------------------------------------------
ENTITY traffic_light IS
  PORT(sensor : IN std_logic;
       clock : IN std_logic;
       red_light : OUT std_logic;
       green_light : OUT std_logic;
       yellow_light : OUT std_logic);
END traffic_light;

ARCHITECTURE simple OF traffic_light IS
   TYPE t_state is (red, green, yellow);
   SIGNAL present_state, next_state : t_state;
BEGIN
   PROCESS(present_state, sensor)
   BEGIN
      CASE present_state IS
         WHEN green =>
            next_state <= yellow;
            red_light <= '0';
            green_light <= '1';
            yellow_light <= '0';
         WHEN red =>
            red_light <= '1';
            green_light <= '0';
            yellow_light <= '0';
            IF (sensor = '1') THEN
               next_state <= green;
            ELSE
               next_state <= red;
            END IF;
         WHEN yellow =>
            red_light <= '0';
            green_light <= '0';
            yellow_light <= '1';
            next_state <= red;
      END CASE;
   END PROCESS;

   PROCESS
   BEGIN
      WAIT UNTIL clock'EVENT and clock = '1';
      present_state <= next_state;
   END PROCESS;
END simple;


